require( "scripts/style.lua" );

StartHelpScreenTimer();
SetPauseMenuCanShow(false);
SetConfirmExitCanShow(true);

MakeDialog
{
    Window
    {
        x=0,y=0,w=800,h=600,
        Bitmap
        {
            name="helppanel1",
            image="ui/surfaces/fullscreendialog",
            x=0,y=0,w=800,h=600,

			SetStyle(CreateTextStyle(FontGame, 32, RedColor)),
			Text
			{
				x=kCenter,y=10,w=kMax,h=40,
				flags = kVAlignCenter + kHAlignCenter,
				name = "helptitle",
				label= "helptitle",
			},

            --SetStyle(CreateTextStyle(FontGame, 18, BlackColor)),
            --CreateText(0, kCenter + 280, "#"..GetString("version",GetConfig(kGameVersion)), 0, 0),

            --Basic Rules
            SetStyle(CreateTextStyle(FontHelp, 28, DarkRedColor)),
            Text
            {
                label="helpTopic0101",
                x = 350, y = 60,
                w=100,h=40,
            },

            --Keep customers happy by serving them as fast as you can.
            SetStyle(CreateTextStyle(FontHelp, 24, BlackColor)),
            Text
            {
                label="help0101",
                x = 100, y = 70,
                w=130,h=160,
            },
            
            Bitmap
            {
				image="help/happy",
				x=30,y=100,
            },
            
            --The happier they are, the more money you will earn.
            SetStyle(CreateTextStyle(FontHelp, 24, BlackColor)),
            Text
            {
                label="help0102",
                x = 420, y = 70,
                w=140,h=160,
            },
            
            Bitmap
            {
				image="help/happy_money",
				x=270,y=100,
            },
            
            --If customers wait too long, they will get upset and leave.
            SetStyle(CreateTextStyle(FontHelp, 24, BlackColor)),
            Text
            {
                label="help0103",
                x = 650, y = 70,
                w=120,h=160,
            },
            
            Bitmap
            {
				image="help/very_hungry",
				x=580,y=100,
            },
            
            --Reach the target number of money to win a level.
            SetStyle(CreateTextStyle(FontHelp, 24, BlackColor)),
            Text
            {
                label="help0104",
                x = 180, y = 210,
                w=120,h=160,
            },
            
            Bitmap
            {
				image="help/goal",
				x=320,y=250,

				SetStyle(CreateTextStyle(FontGame, 16, BlackColor)),
				Text
				{
					label="goal",
					x=139,y=kCenter + 9,
					w=50,h=kMax,
					flags=kHAlignCenter+kVAlignCenter,
				},
            },

            --Seating Customers
            SetStyle(CreateTextStyle(FontHelp, 28, DarkRedColor)),
            Text
            {
                label="helpTopic0102",
                x = 320, y = 350,
                w=160,h=40,
            },
            
            --Click and drag a customer group to clean places at counter.
            SetStyle(CreateTextStyle(FontHelp, 24, BlackColor)),
            Text
            {
                label="help0105",
                x = 50, y = 390,
                w=120,h=160,
            },
            
            --Place them in matching color seats for a bonus.
            SetStyle(CreateTextStyle(FontHelp, 24, BlackColor)),
            Text
            {
                label="help0106",
                x = 350, y = 390,
                w=100,h=160,
            },
            
            Bitmap
            {
				image="help/color_place",
				x=210,y=390,
            },
            
            --The more times you match a seat color, the bigger the bonus!
            SetStyle(CreateTextStyle(FontHelp, 24, BlackColor)),
            Text
            {
                label="help0107",
                x = 630, y = 390,
                w=120,h=160,
            },

            Bitmap
            {
				image="help/color_match",
				x=500,y=390,
            },

            SetStyle(CreatePushButtonStyle(StandardButtonGraphics, DefaultButtonSound)),
            Button
            {
                name="back",
                align=kHAlignLeft+kVAlignBottom,
                x=40,y=kMax-10,
                close = true,
                command=
                    function()
                        PlaySound("audio/sfx/menu/switch_screen.ogg");
                        StopMetricTimers();
                    end,
		        SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
		        CreateText(2,2,"back", 0, 0),
		        SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
		        CreateText(0,0,"back", 0, 0),
            },
            
            SetStyle(CreatePushButtonStyle(StandardButtonGraphics, DefaultButtonSound)),
            Button
            {
                name="next",
                align=kHAlignRight+kVAlignBottom,
                x=kMax-40,y=kMax-10,
                command=function()
					SwapToModal("scripts/help2.lua");
				end,
		        SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
		        CreateText(2,2,"next", 0, 0),
		        SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
		        CreateText(0,0,"next", 0, 0),
            }
        },
    },
}

